#ifndef CAPPLICATION_H
#define CAPPLICATION_H

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/OpenGlut.h>
#include <GL/glext.h>
#include <math.h>

#include "CubeCiel.h"
#include "CTerrainSplited.h"
#include "Texture.h"
//#include "Cbob.h"
#include "particules.h"
#include "CPartEmmit.h"
//#include "Collide.h"
//#include "manette.h"
#include "Joueur.h"
#include "CProjectil.h"
#include "Ennemis.h"
#include "Music.h"
#include "AnimTex.h"
#include "Son.h"

class CApplication
{
 private:
        //CallBack
         friend void recharge(int w,int h);
         friend void mouseMove(int x,int y);
         friend void mouseWheel(int wheel,int direction,int x,int y);
         friend void mouse(int bouton,int etat,int x,int y);
         friend void keybDown(unsigned char c,int x,int y);
         friend void keybUp(unsigned char c,int x,int y);
         friend void specDown(int key,int x,int y);
         friend void specUp(int key,int x,int y);
         //friend void closeFunc();
         friend void frame();
         friend void display();
         
         //ThreadFct
         /*
         friend void *threadChgMusic(void *data);
         friend void *musicThrdFin(void *data);
         */
         
         //Classe objets
         friend class CJoueur;
         friend class CPartEmmit;
         friend class CProjectil;
         friend class CPartEmmitDisp;
         friend class CItEnnemi;
         friend class CEnnemiMov;
         friend class CEnnemiVolant;
         friend class CEnnemiFixSol;
         friend class CEnnemiFixSol2;
         friend class CMissile;
         friend class CMissileEn;
         friend class CManette;
         
         int oldTime;
         int w,h;
         
         bool pause;
         
         //Pour accder au diffrent objet de la classe application
         static CApplication *selfPointer;
         
         CTerrainSplited trSplt; // terrain infini
         CCubeCiel cCbox;
         CPrototypesBobs protoBob;
         CMoteurCollide mCld;//moteur de collision
         CMoteurParticule mdp;
         
         unsigned char id;
         CMusic o_music;
         CSon o_son;
         
         //Etape du jeu
        enum EStage
        {
            START=0,
            TRAINNING1,
            TRAINNING2,
            FIGHTAREA1,
            FIGHTAREA2,
            FIGHTAREA3,
            FIGHTAREA4,
            FIGHTAREA5,
            FIGHTAREA5Bis,
            FIGHTAREA6,
            FIGHTAREA7,
            FIGHTAREA8,
            FIGHTAREA9,
            FIGHTAREA9Bis,
            FIGHTAREAF,
            FINISH1,
            FINISH2
        };
         
         //progression du jeu
         float ennemisPX;
         float px;
         float progression;
         EStage stg;
         
         CJoueur jr;//joueur
         CManette cMant;//manette
         
         void frameMove();
         void render();
         
         //Fonctions de ntoyage de la classe application.
         void clearApp();
         
         unsigned char getIdProj(unsigned char modeTir,unsigned char project);
         
         //Fonctions d'ajout d'nnemis
         void addEnnemiVOLShip2(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot);
         void addEnnemiVOLShip3(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot);
         void addEnnemiVOLShip4(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot);
         void addEnnemiVOLShip5(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot);
         void addEnnemiVOLShip6(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot);
         void addEnnemiVOLShip7(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot);
         void addEnnemiVOLShip8(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot);
         void addEnnemiVOLShip9(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot);
         
         void addEnnemiFIXLau(float precision,float shield,unsigned char project,unsigned short timeShoot,unsigned char dmgShot);
         void addEnnemiFIXTrr(float precision,float shield,unsigned char project,unsigned short timeShoot,unsigned char dmgShot);
         
         //Retourne le nombre de laser tirs suivant un mode de tire.
         unsigned char getMult(unsigned char mode);
 public:
        CApplication();
        ~CApplication();
        
        //Ouvre une fentre et paramtre les callBack
        void initWindows(int argc,char *argv[],char *wName,int w=640,int h=480,bool fullscreen=false);
        
        //Initialise le jeu
        void initScene();
        
        //Lance le jeu
        int launch();
        
        void setMusicId(unsigned char id);
};

#endif
